/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator;

import lib.toma.animations.AnimationEngine;
import lib.toma.animations.engine.screen.animator.AbstractImportScreen;
import lib.toma.animations.engine.screen.animator.AnimationProject;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.FrameProviderWrapper;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ImportProjectScreen
extends AbstractImportScreen {
    protected static final ITextComponent IMPORT = new StringTextComponent("Import");
    private final IBackgroundAnimationUnsetter unsetter;

    public ImportProjectScreen(AnimatorScreen screen, IBackgroundAnimationUnsetter unsetter) {
        super(screen);
        this.unsetter = unsetter;
    }

    @Override
    protected void placeControlButtons(int totalButtonWidth, int buttonWidth) {
        int y = this.field_230709_l_ - 25;
        this.cancel = (Button)this.func_230480_a_((Widget)new Button(5, y, buttonWidth, 20, DialogScreen.CANCEL, this::cancelClicked));
        this.confirm = (Button)this.func_230480_a_((Widget)new Button(10 + buttonWidth, y, buttonWidth, 20, IMPORT, this::confirmClicked));
    }

    protected FrameProviderWrapper obtainWrapper(Animator animator, String path) {
        return animator.getWrapper(path);
    }

    @Override
    protected void confirmClicked(Button button) {
        Animator animator = Animator.get();
        this.unsetBackgroundAnimation();
        FrameProviderWrapper wrapper = this.obtainWrapper(animator, this.getSelectedPath());
        if (wrapper != null) {
            animator.setUsingProject(new AnimationProject(wrapper));
            AnimationEngine.get().pipeline().insert(Animator.ANIMATOR_TYPE);
        }
        this.showParent();
    }

    protected void unsetBackgroundAnimation() {
        this.unsetter.clearBackgroundAnimation();
    }

    @FunctionalInterface
    public static interface IBackgroundAnimationUnsetter {
        public void clearBackgroundAnimation();
    }
}

